----- CELL GT11_DUAL -----
-------------------------------------------------------------------------------
-- Copyright (c) 1995-2004 Xilinx, Inc.
-- All Right Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /    Vendor : Xilinx
-- \   \   \/     Version : 11.1
--  \   \         Description : Xilinx Functional Simulation Library Component
--  /   /                  11-Gigabit Transceiver for High-Speed I/O DUAL Simulation Model
-- /___/   /\     Filename : GT11_DUAL.vhd
-- \   \  /  \    Timestamp : Fri Jun 18 10:57:01 PDT 2004
--  \___\/\___\
--
-- Revision:
--    03/23/04 - Initial version.
--    05/16/05 - Changed default values for some parameters and removed two parameters. Fixed CR#207101.
--    09/06/05 - Fixed CR#215006. Attribute default values update.
--    02/28/06 - CR#226322 - Addition of new parameters and change of default values for some parameters.
--    End Revision

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.VITAL_Timing.all;

library unisim;
use unisim.VCOMPONENTS.all; 

library secureip; 
use secureip.all; 

entity GT11_DUAL is
generic (
		ALIGN_COMMA_WORD_A : integer := 4;
		ALIGN_COMMA_WORD_B : integer := 4;
		BANDGAPSEL_A : boolean := FALSE;
		BANDGAPSEL_B : boolean := FALSE;
		BIASRESSEL_A : boolean := FALSE;
		BIASRESSEL_B : boolean := FALSE;
		CCCB_ARBITRATOR_DISABLE_A : boolean := FALSE;
		CCCB_ARBITRATOR_DISABLE_B : boolean := FALSE;
		CHAN_BOND_LIMIT_A : integer := 16;
		CHAN_BOND_LIMIT_B : integer := 16;
		CHAN_BOND_MODE_A : string := "NONE";
		CHAN_BOND_MODE_B : string := "NONE";
		CHAN_BOND_ONE_SHOT_A : boolean := FALSE;
		CHAN_BOND_ONE_SHOT_B : boolean := FALSE;
		CHAN_BOND_SEQ_1_1_A : bit_vector := "00000000000";
		CHAN_BOND_SEQ_1_1_B : bit_vector := "00000000000";
		CHAN_BOND_SEQ_1_2_A : bit_vector := "00000000000";
		CHAN_BOND_SEQ_1_2_B : bit_vector := "00000000000";
		CHAN_BOND_SEQ_1_3_A : bit_vector := "00000000000";
		CHAN_BOND_SEQ_1_3_B : bit_vector := "00000000000";
		CHAN_BOND_SEQ_1_4_A : bit_vector := "00000000000";
		CHAN_BOND_SEQ_1_4_B : bit_vector := "00000000000";
		CHAN_BOND_SEQ_1_MASK_A : bit_vector := "1110";
		CHAN_BOND_SEQ_1_MASK_B : bit_vector := "1110";
		CHAN_BOND_SEQ_2_1_A : bit_vector := "00000000000";
		CHAN_BOND_SEQ_2_1_B : bit_vector := "00000000000";
		CHAN_BOND_SEQ_2_2_A : bit_vector := "00000000000";
		CHAN_BOND_SEQ_2_2_B : bit_vector := "00000000000";
		CHAN_BOND_SEQ_2_3_A : bit_vector := "00000000000";
		CHAN_BOND_SEQ_2_3_B : bit_vector := "00000000000";
		CHAN_BOND_SEQ_2_4_A : bit_vector := "00000000000";
		CHAN_BOND_SEQ_2_4_B : bit_vector := "00000000000";
		CHAN_BOND_SEQ_2_MASK_A : bit_vector := "1110";
		CHAN_BOND_SEQ_2_MASK_B : bit_vector := "1110";
		CHAN_BOND_SEQ_2_USE_A : boolean := FALSE;
		CHAN_BOND_SEQ_2_USE_B : boolean := FALSE;
		CHAN_BOND_SEQ_LEN_A : integer := 1;
		CHAN_BOND_SEQ_LEN_B : integer := 1;
		CLK_CORRECT_USE_A : boolean := FALSE;
		CLK_CORRECT_USE_B : boolean := FALSE;
		CLK_COR_8B10B_DE_A : boolean := FALSE;
		CLK_COR_8B10B_DE_B : boolean := FALSE;
		CLK_COR_MAX_LAT_A : integer := 48;
		CLK_COR_MAX_LAT_B : integer := 48;
		CLK_COR_MIN_LAT_A : integer := 36;
		CLK_COR_MIN_LAT_B : integer := 36;
		CLK_COR_SEQ_1_1_A : bit_vector := "00000000000";
		CLK_COR_SEQ_1_1_B : bit_vector := "00000000000";
		CLK_COR_SEQ_1_2_A : bit_vector := "00000000000";
		CLK_COR_SEQ_1_2_B : bit_vector := "00000000000";
		CLK_COR_SEQ_1_3_A : bit_vector := "00000000000";
		CLK_COR_SEQ_1_3_B : bit_vector := "00000000000";
		CLK_COR_SEQ_1_4_A : bit_vector := "00000000000";
		CLK_COR_SEQ_1_4_B : bit_vector := "00000000000";
		CLK_COR_SEQ_1_MASK_A : bit_vector := "1110";
		CLK_COR_SEQ_1_MASK_B : bit_vector := "1110";
		CLK_COR_SEQ_2_1_A : bit_vector := "00000000000";
		CLK_COR_SEQ_2_1_B : bit_vector := "00000000000";
		CLK_COR_SEQ_2_2_A : bit_vector := "00000000000";
		CLK_COR_SEQ_2_2_B : bit_vector := "00000000000";
		CLK_COR_SEQ_2_3_A : bit_vector := "00000000000";
		CLK_COR_SEQ_2_3_B : bit_vector := "00000000000";
		CLK_COR_SEQ_2_4_A : bit_vector := "00000000000";
		CLK_COR_SEQ_2_4_B : bit_vector := "00000000000";
		CLK_COR_SEQ_2_MASK_A : bit_vector := "1110";
		CLK_COR_SEQ_2_MASK_B : bit_vector := "1110";
		CLK_COR_SEQ_2_USE_A : boolean := FALSE;
		CLK_COR_SEQ_2_USE_B : boolean := FALSE;
		CLK_COR_SEQ_DROP_A : boolean := FALSE;
		CLK_COR_SEQ_DROP_B : boolean := FALSE;
		CLK_COR_SEQ_LEN_A : integer := 1;
		CLK_COR_SEQ_LEN_B : integer := 1;
		COMMA32_A : boolean := FALSE;
		COMMA32_B : boolean := FALSE;
		COMMA_10B_MASK_A : bit_vector := X"3FF";
		COMMA_10B_MASK_B : bit_vector := X"3FF";
		CYCLE_LIMIT_SEL_A : bit_vector := "00";
		CYCLE_LIMIT_SEL_B : bit_vector := "00";
		DCDR_FILTER_A : bit_vector := "010";
		DCDR_FILTER_B : bit_vector := "010";
		DEC_MCOMMA_DETECT_A : boolean := TRUE;
		DEC_MCOMMA_DETECT_B : boolean := TRUE;
		DEC_PCOMMA_DETECT_A : boolean := TRUE;
		DEC_PCOMMA_DETECT_B : boolean := TRUE;
		DEC_VALID_COMMA_ONLY_A : boolean := TRUE;
		DEC_VALID_COMMA_ONLY_B : boolean := TRUE;
		DIGRX_FWDCLK_A : bit_vector := "00";
		DIGRX_FWDCLK_B : bit_vector := "00";
		DIGRX_SYNC_MODE_A : boolean := FALSE;
		DIGRX_SYNC_MODE_B : boolean := FALSE;
		ENABLE_DCDR_A : boolean := FALSE;
		ENABLE_DCDR_B : boolean := FALSE;
		FDET_HYS_CAL_A : bit_vector := "010";
		FDET_HYS_CAL_B : bit_vector := "010";
		FDET_HYS_SEL_A : bit_vector := "100";
		FDET_HYS_SEL_B : bit_vector := "100";
		FDET_LCK_CAL_A : bit_vector := "100";
		FDET_LCK_CAL_B : bit_vector := "100";
		FDET_LCK_SEL_A : bit_vector := "001";
		FDET_LCK_SEL_B : bit_vector := "001";
		IREFBIASMODE_A : bit_vector := "11";
		IREFBIASMODE_B : bit_vector := "11";
		LOOPCAL_WAIT_A : bit_vector := "00";
		LOOPCAL_WAIT_B : bit_vector := "00";
		MCOMMA_32B_VALUE_A : bit_vector := X"00000000";
		MCOMMA_32B_VALUE_B : bit_vector := X"00000000";
		MCOMMA_DETECT_A : boolean := TRUE;
		MCOMMA_DETECT_B : boolean := TRUE;
		OPPOSITE_SELECT_A : boolean := FALSE;
		OPPOSITE_SELECT_B : boolean := FALSE;
		PCOMMA_32B_VALUE_A : bit_vector := X"00000000";
		PCOMMA_32B_VALUE_B : bit_vector := X"00000000";
		PCOMMA_DETECT_A : boolean := TRUE;
		PCOMMA_DETECT_B : boolean := TRUE;
		PCS_BIT_SLIP_A : boolean := FALSE;
		PCS_BIT_SLIP_B : boolean := FALSE;
		PMACLKENABLE_A : boolean := TRUE;
		PMACLKENABLE_B : boolean := TRUE;
		PMACOREPWRENABLE_A : boolean := TRUE;
		PMACOREPWRENABLE_B : boolean := TRUE;
		PMAIREFTRIM_A : bit_vector := "0111";
		PMAIREFTRIM_B : bit_vector := "0111";
		PMAVBGCTRL_A : bit_vector := "00000";
		PMAVBGCTRL_B : bit_vector := "00000";
		PMAVREFTRIM_A : bit_vector := "0111";
		PMAVREFTRIM_B : bit_vector := "0111";
		PMA_BIT_SLIP_A : boolean := FALSE;
		PMA_BIT_SLIP_B : boolean := FALSE;
		POWER_ENABLE_A : boolean := TRUE;
		POWER_ENABLE_B : boolean := TRUE;
		REPEATER_A : boolean := FALSE;
		REPEATER_B : boolean := FALSE;
		RXACTST_A : boolean := FALSE;
		RXACTST_B : boolean := FALSE;
		RXAFEEQ_A : bit_vector := "000000000";
		RXAFEEQ_B : bit_vector := "000000000";
		RXAFEPD_A : boolean := FALSE;
		RXAFEPD_B : boolean := FALSE;
		RXAFETST_A : boolean := FALSE;
		RXAFETST_B : boolean := FALSE;
		RXAPD_A : boolean := FALSE;
		RXAPD_B : boolean := FALSE;
		RXAREGCTRL_A : bit_vector := "00000";
		RXAREGCTRL_B : bit_vector := "00000";
		RXASYNCDIVIDE_A : bit_vector := "11";
		RXASYNCDIVIDE_B : bit_vector := "11";
		RXBY_32_A : boolean := FALSE;
		RXBY_32_B : boolean := FALSE;
		RXCDRLOS_A : bit_vector := "000000";
		RXCDRLOS_B : bit_vector := "000000";
		RXCLK0_FORCE_PMACLK_A : boolean := FALSE;
		RXCLK0_FORCE_PMACLK_B : boolean := FALSE;
		RXCLKMODE_A : bit_vector := "110001";
		RXCLKMODE_B : bit_vector := "110001";
		RXCLMODE_A : bit_vector := "00";
		RXCLMODE_B : bit_vector := "00";
		RXCMADJ_A : bit_vector := "01";
		RXCMADJ_B : bit_vector := "01";
		RXCPSEL_A : boolean := TRUE;
		RXCPSEL_B : boolean := TRUE;
		RXCPTST_A : boolean := FALSE;
		RXCPTST_B : boolean := FALSE;
		RXCRCCLOCKDOUBLE_A : boolean := FALSE;
		RXCRCCLOCKDOUBLE_B : boolean := FALSE;
		RXCRCENABLE_A : boolean := FALSE;
		RXCRCENABLE_B : boolean := FALSE;
		RXCRCINITVAL_A : bit_vector := X"00000000";
		RXCRCINITVAL_B : bit_vector := X"00000000";
		RXCRCINVERTGEN_A : boolean := FALSE;
		RXCRCINVERTGEN_B : boolean := FALSE;
		RXCRCSAMECLOCK_A : boolean := FALSE;
		RXCRCSAMECLOCK_B : boolean := FALSE;
		RXCTRL1_A : bit_vector := X"200";
		RXCTRL1_B : bit_vector := X"200";
		RXCYCLE_LIMIT_SEL_A : bit_vector := "00";
		RXCYCLE_LIMIT_SEL_B : bit_vector := "00";
		RXDATA_SEL_A : bit_vector := "00";
		RXDATA_SEL_B : bit_vector := "00";
		RXDCCOUPLE_A : boolean := FALSE;
		RXDCCOUPLE_B : boolean := FALSE;
		RXDIGRESET_A : boolean := FALSE;
		RXDIGRESET_B : boolean := FALSE;
		RXDIGRX_A : boolean := FALSE;
		RXDIGRX_B : boolean := FALSE;
		RXEQ_A : bit_vector := X"4000000000000000";
		RXEQ_B : bit_vector := X"4000000000000000";
		RXFDCAL_CLOCK_DIVIDE_A : string := "NONE";
		RXFDCAL_CLOCK_DIVIDE_B : string := "NONE";
		RXFDET_HYS_CAL_A : bit_vector := "010";
		RXFDET_HYS_CAL_B : bit_vector := "010";
		RXFDET_HYS_SEL_A : bit_vector := "100";
		RXFDET_HYS_SEL_B : bit_vector := "100";
		RXFDET_LCK_CAL_A : bit_vector := "100";
		RXFDET_LCK_CAL_B : bit_vector := "100";
		RXFDET_LCK_SEL_A : bit_vector := "001";
		RXFDET_LCK_SEL_B : bit_vector := "001";
		RXFECONTROL1_A : bit_vector := "00";
		RXFECONTROL1_B : bit_vector := "00";
		RXFECONTROL2_A : bit_vector := "000";
		RXFECONTROL2_B : bit_vector := "000";
		RXFETUNE_A : bit_vector := "01";
		RXFETUNE_B : bit_vector := "01";
		RXLB_A : boolean := FALSE;
		RXLB_B : boolean := FALSE;
		RXLKADJ_A : bit_vector := "00000";
		RXLKADJ_B : bit_vector := "00000";
		RXLKAPD_A : boolean := FALSE;
		RXLKAPD_B : boolean := FALSE;
		RXLOOPCAL_WAIT_A : bit_vector := "00";
		RXLOOPCAL_WAIT_B : bit_vector := "00";
		RXLOOPFILT_A : bit_vector := "0111";
		RXLOOPFILT_B : bit_vector := "0111";
		RXMODE_A : bit_vector := "000000";
		RXMODE_B : bit_vector := "000000";
		RXOUTDIV2SEL_A : integer := 1;
		RXOUTDIV2SEL_B : integer := 1;
		RXPDDTST_A : boolean := TRUE;
		RXPDDTST_B : boolean := TRUE;
		RXPD_A : boolean := FALSE;
		RXPD_B : boolean := FALSE;
		RXPLLNDIVSEL_A : integer := 8;
		RXPLLNDIVSEL_B : integer := 8;
		RXPMACLKSEL_A : string := "REFCLK1";
		RXPMACLKSEL_B : string := "REFCLK1";
		RXRCPADJ_A : bit_vector := "011";
		RXRCPADJ_B : bit_vector := "011";
		RXRCPPD_A : boolean := FALSE;
		RXRCPPD_B : boolean := FALSE;
		RXRECCLK1_USE_SYNC_A : boolean := FALSE;
		RXRECCLK1_USE_SYNC_B : boolean := FALSE;
		RXRIBADJ_A : bit_vector := "11";
		RXRIBADJ_B : bit_vector := "11";
		RXRPDPD_A : boolean := FALSE;
		RXRPDPD_B : boolean := FALSE;
		RXRSDPD_A : boolean := FALSE;
		RXRSDPD_B : boolean := FALSE;
		RXSLOWDOWN_CAL_A : bit_vector := "00";
		RXSLOWDOWN_CAL_B : bit_vector := "00";
		RXTUNE_A : bit_vector := X"0000";
		RXTUNE_B : bit_vector := X"0000";
		RXUSRDIVISOR_A : integer := 1;
		RXUSRDIVISOR_B : integer := 1;
		RXVCODAC_INIT_A : bit_vector := "1010000000";
		RXVCODAC_INIT_B : bit_vector := "1010000000";
		RXVCO_CTRL_ENABLE_A : boolean := FALSE;
		RXVCO_CTRL_ENABLE_B : boolean := FALSE;
		RX_BUFFER_USE_A : boolean := TRUE;
		RX_BUFFER_USE_B : boolean := TRUE;
		RX_CLOCK_DIVIDER_A : bit_vector := "00";
		RX_CLOCK_DIVIDER_B : bit_vector := "00";
		SAMPLE_8X_A : boolean := FALSE;
		SAMPLE_8X_B : boolean := FALSE;
		SH_CNT_MAX_A : integer := 64;
		SH_CNT_MAX_B : integer := 64;
		SH_INVALID_CNT_MAX_A : integer := 16;
		SH_INVALID_CNT_MAX_B : integer := 16;
		SLOWDOWN_CAL_A : bit_vector := "00";
		SLOWDOWN_CAL_B : bit_vector := "00";
		TXABPMACLKSEL_A : string := "REFCLK1";
		TXABPMACLKSEL_B : string := "REFCLK1";
		TXAPD_A : boolean := FALSE;
		TXAPD_B : boolean := FALSE;
		TXAREFBIASSEL_A : boolean := TRUE;
		TXAREFBIASSEL_B : boolean := TRUE;
		TXASYNCDIVIDE_A : bit_vector := "11";
		TXASYNCDIVIDE_B : bit_vector := "11";
		TXCLK0_FORCE_PMACLK_A : boolean := FALSE;
		TXCLK0_FORCE_PMACLK_B : boolean := FALSE;
		TXCLKMODE_A : bit_vector := "1001";
		TXCLKMODE_B : bit_vector := "1001";
		TXCLMODE_A : bit_vector := "00";
		TXCLMODE_B : bit_vector := "00";
		TXCPSEL_A : boolean := TRUE;
		TXCPSEL_B : boolean := TRUE;
		TXCRCCLOCKDOUBLE_A : boolean := FALSE;
		TXCRCCLOCKDOUBLE_B : boolean := FALSE;
		TXCRCENABLE_A : boolean := FALSE;
		TXCRCENABLE_B : boolean := FALSE;
		TXCRCINITVAL_A : bit_vector := X"00000000";
		TXCRCINITVAL_B : bit_vector := X"00000000";
		TXCRCINVERTGEN_A : boolean := FALSE;
		TXCRCINVERTGEN_B : boolean := FALSE;
		TXCRCSAMECLOCK_A : boolean := FALSE;
		TXCRCSAMECLOCK_B : boolean := FALSE;
		TXCTRL1_A : bit_vector := X"200";
		TXCTRL1_B : bit_vector := X"200";
		TXDATA_SEL_A : bit_vector := "00";
		TXDATA_SEL_B : bit_vector := "00";
		TXDAT_PRDRV_DAC_A : bit_vector := "111";
		TXDAT_PRDRV_DAC_B : bit_vector := "111";
		TXDAT_TAP_DAC_A : bit_vector := "10110";
		TXDAT_TAP_DAC_B : bit_vector := "10110";
		TXDIGPD_A : boolean := FALSE;
		TXDIGPD_B : boolean := FALSE;
		TXFDCAL_CLOCK_DIVIDE_A : string := "NONE";
		TXFDCAL_CLOCK_DIVIDE_B : string := "NONE";
		TXHIGHSIGNALEN_A : boolean := TRUE;
		TXHIGHSIGNALEN_B : boolean := TRUE;
		TXLOOPFILT_A : bit_vector := "0111";
		TXLOOPFILT_B : bit_vector := "0111";
		TXLVLSHFTPD_A : boolean := FALSE;
		TXLVLSHFTPD_B : boolean := FALSE;
		TXOUTCLK1_USE_SYNC_A : boolean := FALSE;
		TXOUTCLK1_USE_SYNC_B : boolean := FALSE;
		TXOUTDIV2SEL_A : integer := 1;
		TXOUTDIV2SEL_B : integer := 1;
		TXPD_A : boolean := FALSE;
		TXPD_B : boolean := FALSE;
		TXPHASESEL_A : boolean := FALSE;
		TXPHASESEL_B : boolean := FALSE;
		TXPLLNDIVSEL_A : integer := 8;
		TXPLLNDIVSEL_B : integer := 8;
		TXPOST_PRDRV_DAC_A : bit_vector := "111";
		TXPOST_PRDRV_DAC_B : bit_vector := "111";
		TXPOST_TAP_DAC_A : bit_vector := "01110";
		TXPOST_TAP_DAC_B : bit_vector := "01110";
		TXPOST_TAP_PD_A : boolean := TRUE;
		TXPOST_TAP_PD_B : boolean := TRUE;
		TXPRE_PRDRV_DAC_A : bit_vector := "111";
		TXPRE_PRDRV_DAC_B : bit_vector := "111";
		TXPRE_TAP_DAC_A : bit_vector := "00000";
		TXPRE_TAP_DAC_B : bit_vector := "00000";
		TXPRE_TAP_PD_A : boolean := TRUE;
		TXPRE_TAP_PD_B : boolean := TRUE;
		TXSLEWRATE_A : boolean := FALSE;
		TXSLEWRATE_B : boolean := FALSE;
		TXTERMTRIM_A : bit_vector := "1100";
		TXTERMTRIM_B : bit_vector := "1100";
		TXTUNE_A : bit_vector := X"0000";
		TXTUNE_B : bit_vector := X"0000";
		TX_BUFFER_USE_A : boolean := TRUE;
		TX_BUFFER_USE_B : boolean := TRUE;
		TX_CLOCK_DIVIDER_A : bit_vector := "00";
		TX_CLOCK_DIVIDER_B : bit_vector := "00";
		VCODAC_INIT_A : bit_vector := "1010000000";
		VCODAC_INIT_B : bit_vector := "1010000000";
		VCO_CTRL_ENABLE_A : boolean := FALSE;
		VCO_CTRL_ENABLE_B : boolean := FALSE;
		VREFBIASMODE_A : bit_vector := "11";
		VREFBIASMODE_B : bit_vector := "11"
  );

port (
		CHBONDOA : out std_logic_vector(4 downto 0);
		CHBONDOB : out std_logic_vector(4 downto 0);
		DOA : out std_logic_vector(15 downto 0);
		DOB : out std_logic_vector(15 downto 0);
		DRDYA : out std_ulogic;
		DRDYB : out std_ulogic;
		RXBUFERRA : out std_ulogic;
		RXBUFERRB : out std_ulogic;
		RXCALFAILA : out std_ulogic;
		RXCALFAILB : out std_ulogic;
		RXCHARISCOMMAA : out std_logic_vector(7 downto 0);
		RXCHARISCOMMAB : out std_logic_vector(7 downto 0);
		RXCHARISKA : out std_logic_vector(7 downto 0);
		RXCHARISKB : out std_logic_vector(7 downto 0);
		RXCOMMADETA : out std_ulogic;
		RXCOMMADETB : out std_ulogic;
		RXCRCOUTA : out std_logic_vector(31 downto 0);
		RXCRCOUTB : out std_logic_vector(31 downto 0);
		RXCYCLELIMITA : out std_ulogic;
		RXCYCLELIMITB : out std_ulogic;
		RXDATAA : out std_logic_vector(63 downto 0);
		RXDATAB : out std_logic_vector(63 downto 0);
		RXDISPERRA : out std_logic_vector(7 downto 0);
		RXDISPERRB : out std_logic_vector(7 downto 0);
		RXLOCKA : out std_ulogic;
		RXLOCKB : out std_ulogic;
		RXLOSSOFSYNCA : out std_logic_vector(1 downto 0);
		RXLOSSOFSYNCB : out std_logic_vector(1 downto 0);
		RXMCLKA : out std_ulogic;
		RXMCLKB : out std_ulogic;
		RXNOTINTABLEA : out std_logic_vector(7 downto 0);
		RXNOTINTABLEB : out std_logic_vector(7 downto 0);
		RXPCSHCLKOUTA : out std_ulogic;
		RXPCSHCLKOUTB : out std_ulogic;
		RXREALIGNA : out std_ulogic;
		RXREALIGNB : out std_ulogic;
		RXRECCLK1A : out std_ulogic;
		RXRECCLK1B : out std_ulogic;
		RXRECCLK2A : out std_ulogic;
		RXRECCLK2B : out std_ulogic;
		RXRUNDISPA : out std_logic_vector(7 downto 0);
		RXRUNDISPB : out std_logic_vector(7 downto 0);
		RXSIGDETA : out std_ulogic;
		RXSIGDETB : out std_ulogic;
		RXSTATUSA : out std_logic_vector(5 downto 0);
		RXSTATUSB : out std_logic_vector(5 downto 0);
		TX1NA : out std_ulogic;
		TX1NB : out std_ulogic;
		TX1PA : out std_ulogic;
		TX1PB : out std_ulogic;
		TXBUFERRA : out std_ulogic;
		TXBUFERRB : out std_ulogic;
		TXCALFAILA : out std_ulogic;
		TXCALFAILB : out std_ulogic;
		TXCRCOUTA : out std_logic_vector(31 downto 0);
		TXCRCOUTB : out std_logic_vector(31 downto 0);
		TXCYCLELIMITA : out std_ulogic;
		TXCYCLELIMITB : out std_ulogic;
		TXKERRA : out std_logic_vector(7 downto 0);
		TXKERRB : out std_logic_vector(7 downto 0);
		TXLOCKA : out std_ulogic;
		TXLOCKB : out std_ulogic;
		TXOUTCLK1A : out std_ulogic;
		TXOUTCLK1B : out std_ulogic;
		TXOUTCLK2A : out std_ulogic;
		TXOUTCLK2B : out std_ulogic;
		TXPCSHCLKOUTA : out std_ulogic;
		TXPCSHCLKOUTB : out std_ulogic;
		TXRUNDISPA : out std_logic_vector(7 downto 0);
		TXRUNDISPB : out std_logic_vector(7 downto 0);

		CHBONDIA : in std_logic_vector(4 downto 0);
		CHBONDIB : in std_logic_vector(4 downto 0);
		DADDRA : in std_logic_vector(7 downto 0);
		DADDRB : in std_logic_vector(7 downto 0);
		DCLKA : in std_ulogic;
		DCLKB : in std_ulogic;
		DENA : in std_ulogic;
		DENB : in std_ulogic;
		DIA : in std_logic_vector(15 downto 0);
		DIB : in std_logic_vector(15 downto 0);
		DWEA : in std_ulogic;
		DWEB : in std_ulogic;
		ENCHANSYNCA : in std_ulogic;
		ENCHANSYNCB : in std_ulogic;
		ENMCOMMAALIGNA : in std_ulogic;
		ENMCOMMAALIGNB : in std_ulogic;
		ENPCOMMAALIGNA : in std_ulogic;
		ENPCOMMAALIGNB : in std_ulogic;
		GREFCLKA : in std_ulogic;
		GREFCLKB : in std_ulogic;
		LOOPBACKA : in std_logic_vector(1 downto 0);
		LOOPBACKB : in std_logic_vector(1 downto 0);
		POWERDOWNA : in std_ulogic;
		POWERDOWNB : in std_ulogic;
		REFCLK1A : in std_ulogic;
		REFCLK1B : in std_ulogic;
		REFCLK2A : in std_ulogic;
		REFCLK2B : in std_ulogic;
		RX1NA : in std_ulogic;
		RX1NB : in std_ulogic;
		RX1PA : in std_ulogic;
		RX1PB : in std_ulogic;
		RXBLOCKSYNC64B66BUSEA : in std_ulogic;
		RXBLOCKSYNC64B66BUSEB : in std_ulogic;
		RXCLKSTABLEA : in std_ulogic;
		RXCLKSTABLEB : in std_ulogic;
		RXCOMMADETUSEA : in std_ulogic;
		RXCOMMADETUSEB : in std_ulogic;
		RXCRCCLKA : in std_ulogic;
		RXCRCCLKB : in std_ulogic;
		RXCRCDATAVALIDA : in std_ulogic;
		RXCRCDATAVALIDB : in std_ulogic;
		RXCRCDATAWIDTHA : in std_logic_vector(2 downto 0);
		RXCRCDATAWIDTHB : in std_logic_vector(2 downto 0);
		RXCRCINA : in std_logic_vector(63 downto 0);
		RXCRCINB : in std_logic_vector(63 downto 0);
		RXCRCINITA : in std_ulogic;
		RXCRCINITB : in std_ulogic;
		RXCRCINTCLKA : in std_ulogic;
		RXCRCINTCLKB : in std_ulogic;
		RXCRCPDA : in std_ulogic;
		RXCRCPDB : in std_ulogic;
		RXCRCRESETA : in std_ulogic;
		RXCRCRESETB : in std_ulogic;
		RXDATAWIDTHA : in std_logic_vector(1 downto 0);
		RXDATAWIDTHB : in std_logic_vector(1 downto 0);
		RXDEC64B66BUSEA : in std_ulogic;
		RXDEC64B66BUSEB : in std_ulogic;
		RXDEC8B10BUSEA : in std_ulogic;
		RXDEC8B10BUSEB : in std_ulogic;
		RXDESCRAM64B66BUSEA : in std_ulogic;
		RXDESCRAM64B66BUSEB : in std_ulogic;
		RXIGNOREBTFA : in std_ulogic;
		RXIGNOREBTFB : in std_ulogic;
		RXINTDATAWIDTHA : in std_logic_vector(1 downto 0);
		RXINTDATAWIDTHB : in std_logic_vector(1 downto 0);
		RXPMARESETA : in std_ulogic;
		RXPMARESETB : in std_ulogic;
		RXPOLARITYA : in std_ulogic;
		RXPOLARITYB : in std_ulogic;
		RXRESETA : in std_ulogic;
		RXRESETB : in std_ulogic;
		RXSLIDEA : in std_ulogic;
		RXSLIDEB : in std_ulogic;
		RXSYNCA : in std_ulogic;
		RXSYNCB : in std_ulogic;
		RXUSRCLK2A : in std_ulogic;
		RXUSRCLK2B : in std_ulogic;
		RXUSRCLKA : in std_ulogic;
		RXUSRCLKB : in std_ulogic;
		TXBYPASS8B10BA : in std_logic_vector(7 downto 0);
		TXBYPASS8B10BB : in std_logic_vector(7 downto 0);
		TXCHARDISPMODEA : in std_logic_vector(7 downto 0);
		TXCHARDISPMODEB : in std_logic_vector(7 downto 0);
		TXCHARDISPVALA : in std_logic_vector(7 downto 0);
		TXCHARDISPVALB : in std_logic_vector(7 downto 0);
		TXCHARISKA : in std_logic_vector(7 downto 0);
		TXCHARISKB : in std_logic_vector(7 downto 0);
		TXCLKSTABLEA : in std_ulogic;
		TXCLKSTABLEB : in std_ulogic;
		TXCRCCLKA : in std_ulogic;
		TXCRCCLKB : in std_ulogic;
		TXCRCDATAVALIDA : in std_ulogic;
		TXCRCDATAVALIDB : in std_ulogic;
		TXCRCDATAWIDTHA : in std_logic_vector(2 downto 0);
		TXCRCDATAWIDTHB : in std_logic_vector(2 downto 0);
		TXCRCINA : in std_logic_vector(63 downto 0);
		TXCRCINB : in std_logic_vector(63 downto 0);
		TXCRCINITA : in std_ulogic;
		TXCRCINITB : in std_ulogic;
		TXCRCINTCLKA : in std_ulogic;
		TXCRCINTCLKB : in std_ulogic;
		TXCRCPDA : in std_ulogic;
		TXCRCPDB : in std_ulogic;
		TXCRCRESETA : in std_ulogic;
		TXCRCRESETB : in std_ulogic;
		TXDATAA : in std_logic_vector(63 downto 0);
		TXDATAB : in std_logic_vector(63 downto 0);
		TXDATAWIDTHA : in std_logic_vector(1 downto 0);
		TXDATAWIDTHB : in std_logic_vector(1 downto 0);
		TXENC64B66BUSEA : in std_ulogic;
		TXENC64B66BUSEB : in std_ulogic;
		TXENC8B10BUSEA : in std_ulogic;
		TXENC8B10BUSEB : in std_ulogic;
		TXENOOBA : in std_ulogic;
		TXENOOBB : in std_ulogic;
		TXGEARBOX64B66BUSEA : in std_ulogic;
		TXGEARBOX64B66BUSEB : in std_ulogic;
		TXINHIBITA : in std_ulogic;
		TXINHIBITB : in std_ulogic;
		TXINTDATAWIDTHA : in std_logic_vector(1 downto 0);
		TXINTDATAWIDTHB : in std_logic_vector(1 downto 0);
		TXPMARESETA : in std_ulogic;
		TXPMARESETB : in std_ulogic;
		TXPOLARITYA : in std_ulogic;
		TXPOLARITYB : in std_ulogic;
		TXRESETA : in std_ulogic;
		TXRESETB : in std_ulogic;
		TXSCRAM64B66BUSEA : in std_ulogic;
		TXSCRAM64B66BUSEB : in std_ulogic;
		TXSYNCA : in std_ulogic;
		TXSYNCB : in std_ulogic;
		TXUSRCLK2A : in std_ulogic;
		TXUSRCLK2B : in std_ulogic;
		TXUSRCLKA : in std_ulogic;
		TXUSRCLKB : in std_ulogic
     );
end GT11_DUAL;

architecture GT11_DUAL_V of GT11_DUAL is
signal COMBUSINA : std_logic_vector(15 downto 0);
signal COMBUSINB : std_logic_vector(15 downto 0);  



begin

GT11_inst_a : GT11
	generic map (
ALIGN_COMMA_WORD => ALIGN_COMMA_WORD_A,
BANDGAPSEL => BANDGAPSEL_A,
BIASRESSEL => BIASRESSEL_A,
CCCB_ARBITRATOR_DISABLE => CCCB_ARBITRATOR_DISABLE_A,
CHAN_BOND_LIMIT => CHAN_BOND_LIMIT_A,
CHAN_BOND_MODE => CHAN_BOND_MODE_A,
CHAN_BOND_ONE_SHOT => CHAN_BOND_ONE_SHOT_A,
CHAN_BOND_SEQ_1_1 => CHAN_BOND_SEQ_1_1_A,
CHAN_BOND_SEQ_1_2 => CHAN_BOND_SEQ_1_2_A,
CHAN_BOND_SEQ_1_3 => CHAN_BOND_SEQ_1_3_A,
CHAN_BOND_SEQ_1_4 => CHAN_BOND_SEQ_1_4_A,
CHAN_BOND_SEQ_1_MASK => CHAN_BOND_SEQ_1_MASK_A,
CHAN_BOND_SEQ_2_1 => CHAN_BOND_SEQ_2_1_A,
CHAN_BOND_SEQ_2_2 => CHAN_BOND_SEQ_2_2_A,
CHAN_BOND_SEQ_2_3 => CHAN_BOND_SEQ_2_3_A,
CHAN_BOND_SEQ_2_4 => CHAN_BOND_SEQ_2_4_A,
CHAN_BOND_SEQ_2_MASK => CHAN_BOND_SEQ_2_MASK_A,
CHAN_BOND_SEQ_2_USE => CHAN_BOND_SEQ_2_USE_A,
CHAN_BOND_SEQ_LEN => CHAN_BOND_SEQ_LEN_A,
CLK_CORRECT_USE => CLK_CORRECT_USE_A,
CLK_COR_8B10B_DE => CLK_COR_8B10B_DE_A,
CLK_COR_MAX_LAT => CLK_COR_MAX_LAT_A,
CLK_COR_MIN_LAT => CLK_COR_MIN_LAT_A,
CLK_COR_SEQ_1_1 => CLK_COR_SEQ_1_1_A,
CLK_COR_SEQ_1_2 => CLK_COR_SEQ_1_2_A,
CLK_COR_SEQ_1_3 => CLK_COR_SEQ_1_3_A,
CLK_COR_SEQ_1_4 => CLK_COR_SEQ_1_4_A,
CLK_COR_SEQ_1_MASK => CLK_COR_SEQ_1_MASK_A,
CLK_COR_SEQ_2_1 => CLK_COR_SEQ_2_1_A,
CLK_COR_SEQ_2_2 => CLK_COR_SEQ_2_2_A,
CLK_COR_SEQ_2_3 => CLK_COR_SEQ_2_3_A,
CLK_COR_SEQ_2_4 => CLK_COR_SEQ_2_4_A,
CLK_COR_SEQ_2_MASK => CLK_COR_SEQ_2_MASK_A,
CLK_COR_SEQ_2_USE => CLK_COR_SEQ_2_USE_A,
CLK_COR_SEQ_DROP => CLK_COR_SEQ_DROP_A,
CLK_COR_SEQ_LEN => CLK_COR_SEQ_LEN_A,
COMMA32 => COMMA32_A,
COMMA_10B_MASK => COMMA_10B_MASK_A,
CYCLE_LIMIT_SEL => CYCLE_LIMIT_SEL_A,
DCDR_FILTER => DCDR_FILTER_A,
DEC_MCOMMA_DETECT => DEC_MCOMMA_DETECT_A,
DEC_PCOMMA_DETECT => DEC_PCOMMA_DETECT_A,
DEC_VALID_COMMA_ONLY => DEC_VALID_COMMA_ONLY_A,
DIGRX_FWDCLK => DIGRX_FWDCLK_A,
DIGRX_SYNC_MODE => DIGRX_SYNC_MODE_A,
ENABLE_DCDR => ENABLE_DCDR_A,
FDET_HYS_CAL => FDET_HYS_CAL_A,
FDET_HYS_SEL => FDET_HYS_SEL_A,
FDET_LCK_CAL => FDET_LCK_CAL_A,
FDET_LCK_SEL => FDET_LCK_SEL_A,
GT11_MODE => "A",
IREFBIASMODE => IREFBIASMODE_A,
LOOPCAL_WAIT => LOOPCAL_WAIT_A,
MCOMMA_32B_VALUE => MCOMMA_32B_VALUE_A,
MCOMMA_DETECT => MCOMMA_DETECT_A,
OPPOSITE_SELECT => OPPOSITE_SELECT_A,
PCOMMA_32B_VALUE => PCOMMA_32B_VALUE_A,
PCOMMA_DETECT => PCOMMA_DETECT_A,
PCS_BIT_SLIP => PCS_BIT_SLIP_A,
PMACLKENABLE => PMACLKENABLE_A,
PMACOREPWRENABLE => PMACOREPWRENABLE_A,
PMAIREFTRIM => PMAIREFTRIM_A,
PMAVBGCTRL => PMAVBGCTRL_A,
PMAVREFTRIM => PMAVREFTRIM_A,
PMA_BIT_SLIP => PMA_BIT_SLIP_A,
POWER_ENABLE => POWER_ENABLE_A,
REPEATER => REPEATER_A,
RXACTST => RXACTST_A,
RXAFEEQ => RXAFEEQ_A,
RXAFEPD => RXAFEPD_A,
RXAFETST => RXAFETST_A,
RXAPD => RXAPD_A,
RXAREGCTRL => RXAREGCTRL_A,
RXASYNCDIVIDE => RXASYNCDIVIDE_A,
RXBY_32 => RXBY_32_A,
RXCDRLOS => RXCDRLOS_A,
RXCLK0_FORCE_PMACLK => RXCLK0_FORCE_PMACLK_A,
RXCLKMODE => RXCLKMODE_A,
RXCLMODE => RXCLMODE_A,
RXCMADJ => RXCMADJ_A,
RXCPSEL => RXCPSEL_A,
RXCPTST => RXCPTST_A,
RXCRCCLOCKDOUBLE => RXCRCCLOCKDOUBLE_A,
RXCRCENABLE => RXCRCENABLE_A,
RXCRCINITVAL => RXCRCINITVAL_A,
RXCRCINVERTGEN => RXCRCINVERTGEN_A,
RXCRCSAMECLOCK => RXCRCSAMECLOCK_A,
RXCTRL1 => RXCTRL1_A,
RXCYCLE_LIMIT_SEL => RXCYCLE_LIMIT_SEL_A,
RXDATA_SEL => RXDATA_SEL_A,
RXDCCOUPLE => RXDCCOUPLE_A,
RXDIGRESET => RXDIGRESET_A,
RXDIGRX => RXDIGRX_A,
RXEQ => RXEQ_A,
RXFDCAL_CLOCK_DIVIDE => RXFDCAL_CLOCK_DIVIDE_A,
RXFDET_HYS_CAL => RXFDET_HYS_CAL_A,
RXFDET_HYS_SEL => RXFDET_HYS_SEL_A,
RXFDET_LCK_CAL => RXFDET_LCK_CAL_A,
RXFDET_LCK_SEL => RXFDET_LCK_SEL_A,
RXFECONTROL1 => RXFECONTROL1_A,
RXFECONTROL2 => RXFECONTROL2_A,
RXFETUNE => RXFETUNE_A,
RXLB => RXLB_A,
RXLKADJ => RXLKADJ_A,
RXLKAPD => RXLKAPD_A,
RXLOOPCAL_WAIT => RXLOOPCAL_WAIT_A,
RXLOOPFILT => RXLOOPFILT_A,
RXMODE => RXMODE_A,
RXOUTDIV2SEL => RXOUTDIV2SEL_A,
RXPD => RXPD_A,
RXPDDTST => RXPDDTST_A,
RXPLLNDIVSEL => RXPLLNDIVSEL_A,
RXPMACLKSEL => RXPMACLKSEL_A,
RXRCPADJ => RXRCPADJ_A,
RXRCPPD => RXRCPPD_A,
RXRECCLK1_USE_SYNC => RXRECCLK1_USE_SYNC_A,
RXRIBADJ => RXRIBADJ_A,
RXRPDPD => RXRPDPD_A,
RXRSDPD => RXRSDPD_A,
RXSLOWDOWN_CAL => RXSLOWDOWN_CAL_A,
RXTUNE => RXTUNE_A,
RXUSRDIVISOR => RXUSRDIVISOR_A,
RXVCODAC_INIT => RXVCODAC_INIT_A,
RXVCO_CTRL_ENABLE => RXVCO_CTRL_ENABLE_A,
RX_BUFFER_USE => RX_BUFFER_USE_A,
RX_CLOCK_DIVIDER => RX_CLOCK_DIVIDER_A,
SAMPLE_8X => SAMPLE_8X_A,
SH_CNT_MAX => SH_CNT_MAX_A,
SH_INVALID_CNT_MAX => SH_INVALID_CNT_MAX_A,
SLOWDOWN_CAL => SLOWDOWN_CAL_A,
TXABPMACLKSEL => TXABPMACLKSEL_A,
TXAPD => TXAPD_A,
TXAREFBIASSEL => TXAREFBIASSEL_A,
TXASYNCDIVIDE => TXASYNCDIVIDE_A,
TXCLK0_FORCE_PMACLK => TXCLK0_FORCE_PMACLK_A,
TXCLKMODE => TXCLKMODE_A,
TXCLMODE => TXCLMODE_A,
TXCPSEL => TXCPSEL_A,
TXCRCCLOCKDOUBLE => TXCRCCLOCKDOUBLE_A,
TXCRCENABLE => TXCRCENABLE_A,
TXCRCINITVAL => TXCRCINITVAL_A,
TXCRCINVERTGEN => TXCRCINVERTGEN_A,
TXCRCSAMECLOCK => TXCRCSAMECLOCK_A,
TXCTRL1 => TXCTRL1_A,
TXDATA_SEL => TXDATA_SEL_A,
TXDAT_PRDRV_DAC => TXDAT_PRDRV_DAC_A,
TXDAT_TAP_DAC => TXDAT_TAP_DAC_A,
TXDIGPD => TXDIGPD_A,
TXFDCAL_CLOCK_DIVIDE => TXFDCAL_CLOCK_DIVIDE_A,
TXHIGHSIGNALEN => TXHIGHSIGNALEN_A,
TXLOOPFILT => TXLOOPFILT_A,
TXLVLSHFTPD => TXLVLSHFTPD_A,
TXOUTCLK1_USE_SYNC => TXOUTCLK1_USE_SYNC_A,
TXOUTDIV2SEL => TXOUTDIV2SEL_A,
TXPD => TXPD_A,
TXPHASESEL => TXPHASESEL_A,
TXPLLNDIVSEL => TXPLLNDIVSEL_A,
TXPOST_PRDRV_DAC => TXPOST_PRDRV_DAC_A,
TXPOST_TAP_DAC => TXPOST_TAP_DAC_A,
TXPOST_TAP_PD => TXPOST_TAP_PD_A,
TXPRE_PRDRV_DAC => TXPRE_PRDRV_DAC_A,
TXPRE_TAP_DAC => TXPRE_TAP_DAC_A,
TXPRE_TAP_PD => TXPRE_TAP_PD_A,
TXSLEWRATE => TXSLEWRATE_A,
TXTERMTRIM => TXTERMTRIM_A,
TXTUNE => TXTUNE_A,
TX_BUFFER_USE => TX_BUFFER_USE_A,
TX_CLOCK_DIVIDER => TX_CLOCK_DIVIDER_A,
VCODAC_INIT => VCODAC_INIT_A,
VCO_CTRL_ENABLE => VCO_CTRL_ENABLE_A,
VREFBIASMODE => VREFBIASMODE_A
)
  
port map (
CHBONDO => CHBONDOA,
COMBUSOUT => COMBUSINB,
DO => DOA,
DRDY => DRDYA,
RXBUFERR => RXBUFERRA,
RXCALFAIL => RXCALFAILA,
RXCHARISCOMMA => RXCHARISCOMMAA,
RXCHARISK => RXCHARISKA,
RXCOMMADET => RXCOMMADETA,
RXCRCOUT => RXCRCOUTA,
RXCYCLELIMIT => RXCYCLELIMITA,
RXDATA => RXDATAA,
RXDISPERR => RXDISPERRA,
RXLOCK => RXLOCKA,
RXLOSSOFSYNC => RXLOSSOFSYNCA,
RXMCLK => RXMCLKA,
RXNOTINTABLE => RXNOTINTABLEA,
RXPCSHCLKOUT => RXPCSHCLKOUTA,
RXREALIGN => RXREALIGNA,
RXRECCLK1 => RXRECCLK1A,
RXRECCLK2 => RXRECCLK2A,
RXRUNDISP => RXRUNDISPA,
RXSIGDET => RXSIGDETA,
RXSTATUS => RXSTATUSA,
TX1N => TX1NA,
TX1P => TX1PA,
TXBUFERR => TXBUFERRA,
TXCALFAIL => TXCALFAILA,
TXCRCOUT => TXCRCOUTA,
TXCYCLELIMIT => TXCYCLELIMITA,
TXKERR => TXKERRA,
TXLOCK => TXLOCKA,
TXOUTCLK1 => TXOUTCLK1A,
TXOUTCLK2 => TXOUTCLK2A,
TXPCSHCLKOUT => TXPCSHCLKOUTA,
TXRUNDISP => TXRUNDISPA,

CHBONDI => CHBONDIA,
COMBUSIN => COMBUSINA,
DADDR => DADDRA,
DCLK => DCLKA,
DEN => DENA,
DI => DIA,
DWE => DWEA,
ENCHANSYNC => ENCHANSYNCA,
ENMCOMMAALIGN => ENMCOMMAALIGNA,
ENPCOMMAALIGN => ENPCOMMAALIGNA,
GREFCLK => GREFCLKA,
LOOPBACK => LOOPBACKA,
POWERDOWN => POWERDOWNA,
REFCLK1 => REFCLK1A,
REFCLK2 => REFCLK2A,
RX1N => RX1NA,
RX1P => RX1PA,
RXBLOCKSYNC64B66BUSE => RXBLOCKSYNC64B66BUSEA,
RXCLKSTABLE => RXCLKSTABLEA,
RXCOMMADETUSE => RXCOMMADETUSEA,
RXCRCCLK => RXCRCCLKA,
RXCRCDATAVALID => RXCRCDATAVALIDA,
RXCRCDATAWIDTH => RXCRCDATAWIDTHA,
RXCRCIN => RXCRCINA,
RXCRCINIT => RXCRCINITA,
RXCRCINTCLK => RXCRCINTCLKA,
RXCRCPD => RXCRCPDA,
RXCRCRESET => RXCRCRESETA,
RXDATAWIDTH => RXDATAWIDTHA,
RXDEC64B66BUSE => RXDEC64B66BUSEA,
RXDEC8B10BUSE => RXDEC8B10BUSEA,
RXDESCRAM64B66BUSE => RXDESCRAM64B66BUSEA,
RXIGNOREBTF => RXIGNOREBTFA,
RXINTDATAWIDTH => RXINTDATAWIDTHA,
RXPMARESET => RXPMARESETA,
RXPOLARITY => RXPOLARITYA,
RXRESET => RXRESETA,
RXSLIDE => RXSLIDEA,
RXSYNC => RXSYNCA,
RXUSRCLK => RXUSRCLKA,
RXUSRCLK2 => RXUSRCLK2A,
TXBYPASS8B10B => TXBYPASS8B10BA,
TXCHARDISPMODE => TXCHARDISPMODEA,
TXCHARDISPVAL => TXCHARDISPVALA,
TXCHARISK => TXCHARISKA,
TXCLKSTABLE => TXCLKSTABLEA,
TXCRCCLK => TXCRCCLKA,
TXCRCDATAVALID => TXCRCDATAVALIDA,
TXCRCDATAWIDTH => TXCRCDATAWIDTHA,
TXCRCIN => TXCRCINA,
TXCRCINIT => TXCRCINITA,
TXCRCINTCLK => TXCRCINTCLKA,
TXCRCPD => TXCRCPDA,
TXCRCRESET => TXCRCRESETA,
TXDATA => TXDATAA,
TXDATAWIDTH => TXDATAWIDTHA,
TXENC64B66BUSE => TXENC64B66BUSEA,
TXENC8B10BUSE => TXENC8B10BUSEA,
TXENOOB => TXENOOBA,
TXGEARBOX64B66BUSE => TXGEARBOX64B66BUSEA,
TXINHIBIT => TXINHIBITA,
TXINTDATAWIDTH => TXINTDATAWIDTHA,
TXPMARESET => TXPMARESETA,
TXPOLARITY => TXPOLARITYA,
TXRESET => TXRESETA,
TXSCRAM64B66BUSE => TXSCRAM64B66BUSEA,
TXSYNC => TXSYNCA,
TXUSRCLK => TXUSRCLKA,
TXUSRCLK2 => TXUSRCLK2A
);

GT11_inst_b : GT11
	generic map (
ALIGN_COMMA_WORD => ALIGN_COMMA_WORD_B,
BANDGAPSEL => BANDGAPSEL_B,
BIASRESSEL => BIASRESSEL_B,
CCCB_ARBITRATOR_DISABLE => CCCB_ARBITRATOR_DISABLE_B,
CHAN_BOND_LIMIT => CHAN_BOND_LIMIT_B,
CHAN_BOND_MODE => CHAN_BOND_MODE_B,
CHAN_BOND_ONE_SHOT => CHAN_BOND_ONE_SHOT_B,
CHAN_BOND_SEQ_1_1 => CHAN_BOND_SEQ_1_1_B,
CHAN_BOND_SEQ_1_2 => CHAN_BOND_SEQ_1_2_B,
CHAN_BOND_SEQ_1_3 => CHAN_BOND_SEQ_1_3_B,
CHAN_BOND_SEQ_1_4 => CHAN_BOND_SEQ_1_4_B,
CHAN_BOND_SEQ_1_MASK => CHAN_BOND_SEQ_1_MASK_B,
CHAN_BOND_SEQ_2_1 => CHAN_BOND_SEQ_2_1_B,
CHAN_BOND_SEQ_2_2 => CHAN_BOND_SEQ_2_2_B,
CHAN_BOND_SEQ_2_3 => CHAN_BOND_SEQ_2_3_B,
CHAN_BOND_SEQ_2_4 => CHAN_BOND_SEQ_2_4_B,
CHAN_BOND_SEQ_2_MASK => CHAN_BOND_SEQ_2_MASK_B,
CHAN_BOND_SEQ_2_USE => CHAN_BOND_SEQ_2_USE_B,
CHAN_BOND_SEQ_LEN => CHAN_BOND_SEQ_LEN_B,
CLK_CORRECT_USE => CLK_CORRECT_USE_B,
CLK_COR_8B10B_DE => CLK_COR_8B10B_DE_B,
CLK_COR_MAX_LAT => CLK_COR_MAX_LAT_B,
CLK_COR_MIN_LAT => CLK_COR_MIN_LAT_B,
CLK_COR_SEQ_1_1 => CLK_COR_SEQ_1_1_B,
CLK_COR_SEQ_1_2 => CLK_COR_SEQ_1_2_B,
CLK_COR_SEQ_1_3 => CLK_COR_SEQ_1_3_B,
CLK_COR_SEQ_1_4 => CLK_COR_SEQ_1_4_B,
CLK_COR_SEQ_1_MASK => CLK_COR_SEQ_1_MASK_B,
CLK_COR_SEQ_2_1 => CLK_COR_SEQ_2_1_B,
CLK_COR_SEQ_2_2 => CLK_COR_SEQ_2_2_B,
CLK_COR_SEQ_2_3 => CLK_COR_SEQ_2_3_B,
CLK_COR_SEQ_2_4 => CLK_COR_SEQ_2_4_B,
CLK_COR_SEQ_2_MASK => CLK_COR_SEQ_2_MASK_B,
CLK_COR_SEQ_2_USE => CLK_COR_SEQ_2_USE_B,
CLK_COR_SEQ_DROP => CLK_COR_SEQ_DROP_B,
CLK_COR_SEQ_LEN => CLK_COR_SEQ_LEN_B,
COMMA32 => COMMA32_B,
COMMA_10B_MASK => COMMA_10B_MASK_B,
CYCLE_LIMIT_SEL => CYCLE_LIMIT_SEL_B,
DCDR_FILTER => DCDR_FILTER_B,
DEC_MCOMMA_DETECT => DEC_MCOMMA_DETECT_B,
DEC_PCOMMA_DETECT => DEC_PCOMMA_DETECT_B,
DEC_VALID_COMMA_ONLY => DEC_VALID_COMMA_ONLY_B,
DIGRX_FWDCLK => DIGRX_FWDCLK_B,
DIGRX_SYNC_MODE => DIGRX_SYNC_MODE_B,
ENABLE_DCDR => ENABLE_DCDR_B,
FDET_HYS_CAL => FDET_HYS_CAL_B,
FDET_HYS_SEL => FDET_HYS_SEL_B,
FDET_LCK_CAL => FDET_LCK_CAL_B,
FDET_LCK_SEL => FDET_LCK_SEL_B,
GT11_MODE => "B",
IREFBIASMODE => IREFBIASMODE_B,
LOOPCAL_WAIT => LOOPCAL_WAIT_B,
MCOMMA_32B_VALUE => MCOMMA_32B_VALUE_B,
MCOMMA_DETECT => MCOMMA_DETECT_B,
OPPOSITE_SELECT => OPPOSITE_SELECT_B,
PCOMMA_32B_VALUE => PCOMMA_32B_VALUE_B,
PCOMMA_DETECT => PCOMMA_DETECT_B,
PCS_BIT_SLIP => PCS_BIT_SLIP_B,
PMACLKENABLE => PMACLKENABLE_B,
PMACOREPWRENABLE => PMACOREPWRENABLE_B,
PMAIREFTRIM => PMAIREFTRIM_B,
PMAVBGCTRL => PMAVBGCTRL_B,
PMAVREFTRIM => PMAVREFTRIM_B,
PMA_BIT_SLIP => PMA_BIT_SLIP_B,
POWER_ENABLE => POWER_ENABLE_B,
REPEATER => REPEATER_B,
RXACTST => RXACTST_B,
RXAFEEQ => RXAFEEQ_B,
RXAFEPD => RXAFEPD_B,
RXAFETST => RXAFETST_B,
RXAPD => RXAPD_B,
RXAREGCTRL => RXAREGCTRL_B,
RXASYNCDIVIDE => RXASYNCDIVIDE_B,
RXBY_32 => RXBY_32_B,
RXCDRLOS => RXCDRLOS_B,
RXCLK0_FORCE_PMACLK => RXCLK0_FORCE_PMACLK_B,
RXCLKMODE => RXCLKMODE_B,
RXCLMODE => RXCLMODE_B,
RXCMADJ => RXCMADJ_B,
RXCPSEL => RXCPSEL_B,
RXCPTST => RXCPTST_B,
RXCRCCLOCKDOUBLE => RXCRCCLOCKDOUBLE_B,
RXCRCENABLE => RXCRCENABLE_B,
RXCRCINITVAL => RXCRCINITVAL_B,
RXCRCINVERTGEN => RXCRCINVERTGEN_B,
RXCRCSAMECLOCK => RXCRCSAMECLOCK_B,
RXCTRL1 => RXCTRL1_B,
RXCYCLE_LIMIT_SEL => RXCYCLE_LIMIT_SEL_B,
RXDATA_SEL => RXDATA_SEL_B,
RXDCCOUPLE => RXDCCOUPLE_B,
RXDIGRESET => RXDIGRESET_B,
RXDIGRX => RXDIGRX_B,
RXEQ => RXEQ_B,
RXFDCAL_CLOCK_DIVIDE => RXFDCAL_CLOCK_DIVIDE_B,
RXFDET_HYS_CAL => RXFDET_HYS_CAL_B,
RXFDET_HYS_SEL => RXFDET_HYS_SEL_B,
RXFDET_LCK_CAL => RXFDET_LCK_CAL_B,
RXFDET_LCK_SEL => RXFDET_LCK_SEL_B,
RXFECONTROL1 => RXFECONTROL1_B,
RXFECONTROL2 => RXFECONTROL2_B,
RXFETUNE => RXFETUNE_B,
RXLB => RXLB_B,
RXLKADJ => RXLKADJ_B,
RXLKAPD => RXLKAPD_B,
RXLOOPCAL_WAIT => RXLOOPCAL_WAIT_B,
RXLOOPFILT => RXLOOPFILT_B,
RXMODE => RXMODE_B,
RXOUTDIV2SEL => RXOUTDIV2SEL_B,
RXPD => RXPD_B,
RXPDDTST => RXPDDTST_B,
RXPLLNDIVSEL => RXPLLNDIVSEL_B,
RXPMACLKSEL => RXPMACLKSEL_B,
RXRCPADJ => RXRCPADJ_B,
RXRCPPD => RXRCPPD_B,
RXRECCLK1_USE_SYNC => RXRECCLK1_USE_SYNC_B,
RXRIBADJ => RXRIBADJ_B,
RXRPDPD => RXRPDPD_B,
RXRSDPD => RXRSDPD_B,
RXSLOWDOWN_CAL => RXSLOWDOWN_CAL_B,
RXTUNE => RXTUNE_B,
RXUSRDIVISOR => RXUSRDIVISOR_B,
RXVCODAC_INIT => RXVCODAC_INIT_B,
RXVCO_CTRL_ENABLE => RXVCO_CTRL_ENABLE_B,
RX_BUFFER_USE => RX_BUFFER_USE_B,
RX_CLOCK_DIVIDER => RX_CLOCK_DIVIDER_B,
SAMPLE_8X => SAMPLE_8X_B,
SH_CNT_MAX => SH_CNT_MAX_B,
SH_INVALID_CNT_MAX => SH_INVALID_CNT_MAX_B,
SLOWDOWN_CAL => SLOWDOWN_CAL_B,
TXABPMACLKSEL => TXABPMACLKSEL_B,
TXAPD => TXAPD_B,
TXAREFBIASSEL => TXAREFBIASSEL_B,
TXASYNCDIVIDE => TXASYNCDIVIDE_B,
TXCLK0_FORCE_PMACLK => TXCLK0_FORCE_PMACLK_B,
TXCLKMODE => TXCLKMODE_B,
TXCLMODE => TXCLMODE_B,
TXCPSEL => TXCPSEL_B,
TXCRCCLOCKDOUBLE => TXCRCCLOCKDOUBLE_B,
TXCRCENABLE => TXCRCENABLE_B,
TXCRCINITVAL => TXCRCINITVAL_B,
TXCRCINVERTGEN => TXCRCINVERTGEN_B,
TXCRCSAMECLOCK => TXCRCSAMECLOCK_B,
TXCTRL1 => TXCTRL1_B,
TXDATA_SEL => TXDATA_SEL_B,
TXDAT_PRDRV_DAC => TXDAT_PRDRV_DAC_B,
TXDAT_TAP_DAC => TXDAT_TAP_DAC_B,
TXDIGPD => TXDIGPD_B,
TXFDCAL_CLOCK_DIVIDE => TXFDCAL_CLOCK_DIVIDE_B,
TXHIGHSIGNALEN => TXHIGHSIGNALEN_B,
TXLOOPFILT => TXLOOPFILT_B,
TXLVLSHFTPD => TXLVLSHFTPD_B,
TXOUTCLK1_USE_SYNC => TXOUTCLK1_USE_SYNC_B,
TXOUTDIV2SEL => TXOUTDIV2SEL_B,
TXPD => TXPD_B,
TXPHASESEL => TXPHASESEL_B,
TXPLLNDIVSEL => TXPLLNDIVSEL_B,
TXPOST_PRDRV_DAC => TXPOST_PRDRV_DAC_B,
TXPOST_TAP_DAC => TXPOST_TAP_DAC_B,
TXPOST_TAP_PD => TXPOST_TAP_PD_B,
TXPRE_PRDRV_DAC => TXPRE_PRDRV_DAC_B,
TXPRE_TAP_DAC => TXPRE_TAP_DAC_B,
TXPRE_TAP_PD => TXPRE_TAP_PD_B,
TXSLEWRATE => TXSLEWRATE_B,
TXTERMTRIM => TXTERMTRIM_B,
TXTUNE => TXTUNE_B,
TX_BUFFER_USE => TX_BUFFER_USE_B,
TX_CLOCK_DIVIDER => TX_CLOCK_DIVIDER_B,
VCODAC_INIT => VCODAC_INIT_B,
VCO_CTRL_ENABLE => VCO_CTRL_ENABLE_B,
VREFBIASMODE => VREFBIASMODE_B
)
  
port map (
CHBONDO => CHBONDOB,
COMBUSOUT => COMBUSINA,
DO => DOB,
DRDY => DRDYB,
RXBUFERR => RXBUFERRB,
RXCALFAIL => RXCALFAILB,
RXCHARISCOMMA => RXCHARISCOMMAB,
RXCHARISK => RXCHARISKB,
RXCOMMADET => RXCOMMADETB,
RXCRCOUT => RXCRCOUTB,
RXCYCLELIMIT => RXCYCLELIMITB,
RXDATA => RXDATAB,
RXDISPERR => RXDISPERRB,
RXLOCK => RXLOCKB,
RXLOSSOFSYNC => RXLOSSOFSYNCB,
RXMCLK => RXMCLKB,
RXNOTINTABLE => RXNOTINTABLEB,
RXPCSHCLKOUT => RXPCSHCLKOUTB,
RXREALIGN => RXREALIGNB,
RXRECCLK1 => RXRECCLK1B,
RXRECCLK2 => RXRECCLK2B,
RXRUNDISP => RXRUNDISPB,
RXSIGDET => RXSIGDETB,
RXSTATUS => RXSTATUSB,
TX1N => TX1NB,
TX1P => TX1PB,
TXBUFERR => TXBUFERRB,
TXCALFAIL => TXCALFAILB,
TXCRCOUT => TXCRCOUTB,
TXCYCLELIMIT => TXCYCLELIMITB,
TXKERR => TXKERRB,
TXLOCK => TXLOCKB,
TXOUTCLK1 => TXOUTCLK1B,
TXOUTCLK2 => TXOUTCLK2B,
TXPCSHCLKOUT => TXPCSHCLKOUTB,
TXRUNDISP => TXRUNDISPB,

CHBONDI => CHBONDIB,
COMBUSIN => COMBUSINB,
DADDR => DADDRB,
DCLK => DCLKB,
DEN => DENB,
DI => DIB,
DWE => DWEB,
ENCHANSYNC => ENCHANSYNCB,
ENMCOMMAALIGN => ENMCOMMAALIGNB,
ENPCOMMAALIGN => ENPCOMMAALIGNB,
GREFCLK => GREFCLKB,
LOOPBACK => LOOPBACKB,
POWERDOWN => POWERDOWNB,
REFCLK1 => REFCLK1B,
REFCLK2 => REFCLK2B,
RX1N => RX1NB,
RX1P => RX1PB,
RXBLOCKSYNC64B66BUSE => RXBLOCKSYNC64B66BUSEB,
RXCLKSTABLE => RXCLKSTABLEB,
RXCOMMADETUSE => RXCOMMADETUSEB,
RXCRCCLK => RXCRCCLKB,
RXCRCDATAVALID => RXCRCDATAVALIDB,
RXCRCDATAWIDTH => RXCRCDATAWIDTHB,
RXCRCIN => RXCRCINB,
RXCRCINIT => RXCRCINITB,
RXCRCINTCLK => RXCRCINTCLKB,
RXCRCPD => RXCRCPDB,
RXCRCRESET => RXCRCRESETB,
RXDATAWIDTH => RXDATAWIDTHB,
RXDEC64B66BUSE => RXDEC64B66BUSEB,
RXDEC8B10BUSE => RXDEC8B10BUSEB,
RXDESCRAM64B66BUSE => RXDESCRAM64B66BUSEB,
RXIGNOREBTF => RXIGNOREBTFB,
RXINTDATAWIDTH => RXINTDATAWIDTHB,
RXPMARESET => RXPMARESETB,
RXPOLARITY => RXPOLARITYB,
RXRESET => RXRESETB,
RXSLIDE => RXSLIDEB,
RXSYNC => RXSYNCB,
RXUSRCLK => RXUSRCLKB,
RXUSRCLK2 => RXUSRCLK2B,
TXBYPASS8B10B => TXBYPASS8B10BB,
TXCHARDISPMODE => TXCHARDISPMODEB,
TXCHARDISPVAL => TXCHARDISPVALB,
TXCHARISK => TXCHARISKB,
TXCLKSTABLE => TXCLKSTABLEB,
TXCRCCLK => TXCRCCLKB,
TXCRCDATAVALID => TXCRCDATAVALIDB,
TXCRCDATAWIDTH => TXCRCDATAWIDTHB,
TXCRCIN => TXCRCINB,
TXCRCINIT => TXCRCINITB,
TXCRCINTCLK => TXCRCINTCLKB,
TXCRCPD => TXCRCPDB,
TXCRCRESET => TXCRCRESETB,
TXDATA => TXDATAB,
TXDATAWIDTH => TXDATAWIDTHB,
TXENC64B66BUSE => TXENC64B66BUSEB,
TXENC8B10BUSE => TXENC8B10BUSEB,
TXENOOB => TXENOOBB,
TXGEARBOX64B66BUSE => TXGEARBOX64B66BUSEB,
TXINHIBIT => TXINHIBITB,
TXINTDATAWIDTH => TXINTDATAWIDTHB,
TXPMARESET => TXPMARESETB,
TXPOLARITY => TXPOLARITYB,
TXRESET => TXRESETB,
TXSCRAM64B66BUSE => TXSCRAM64B66BUSEB,
TXSYNC => TXSYNCB,
TXUSRCLK => TXUSRCLKB,
TXUSRCLK2 => TXUSRCLK2B
);

end GT11_DUAL_V;
